//
//  MCDelimitedDataReader.h
//  MCFoundation
//
//  Created by Michael Clark on Mon Apr 22 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@protocol MCDataReader

- (unsigned int)count;
- (id)objectForKey:(NSString *)key atIndex:(unsigned int)index;

- (BOOL)purgeRecordAtIndex:(unsigned int)index;
- (void)enableRecordPurging;
- (void)disableRecordPurging;

@end


@interface MCDelimitedDataReader : NSObject <MCDataReader> {
    NSString      *_recordDelimeter;
    NSString      *_fieldDelimeter;
    NSString      *_startingFieldWrapper;
    NSString      *_endingFieldWrapper;

    NSString	  *_rawFileData;

    NSMutableDictionary        *_keyIndexMapping; // Lookup table for keys and their indices
	
	// temp
    NSMutableArray             *_recs;
	
	BOOL						_enablePurging;
	BOOL                        _noFieldNameRow;
    BOOL                        _version2Parsing;
}

// Designated initializer
- (id) initWithRawString: (NSString *) rawString
		 recordDelimeter: (NSString *) recordDelimiter
		  fieldDelimeter: (NSString *) fieldDelimiter
	startingFieldWrapper: (NSString *) startingFieldWrapper
	  endingFieldWrapper: (NSString *) endingFieldWrapper;

- (id) initWithRawString: (NSString *) rawString
              recordDelimeter: (NSString *) recordDelimiter
               fieldDelimeter: (NSString *) fieldDelimiter
         startingFieldWrapper: (NSString *) startingFieldWrapper
           endingFieldWrapper: (NSString *) endingFieldWrapper
		       noFieldNameRow: (BOOL) flag;

- (id)initWithRawString: (NSString *) rawString
        recordDelimeter: (NSString *) recordDelimiter
         fieldDelimeter: (NSString *) fieldDelimiter
   startingFieldWrapper: (NSString *) startingFieldWrapper
     endingFieldWrapper: (NSString *) endingFieldWrapper
         noFieldNameRow: (BOOL) flag
        version2Parsing:(BOOL)shouldUseVersion2Parsing;

// Reads contents of file and then calls designated initializer
- (id) initWithContentsOfFile: (NSString *) path
              recordDelimeter: (NSString *) recordDelimiter
               fieldDelimeter: (NSString *) fieldDelimiter
         startingFieldWrapper: (NSString *) startingFieldWrapper
           endingFieldWrapper: (NSString *) endingFieldWrapper;

- (id) initWithContentsOfFile: (NSString *) path
              recordDelimeter: (NSString *) recordDelimiter
               fieldDelimeter: (NSString *) fieldDelimiter
         startingFieldWrapper: (NSString *) startingFieldWrapper
           endingFieldWrapper: (NSString *) endingFieldWrapper
              version2Parsing:(BOOL)shouldUseVersion2Parsing;


// clears parsed data - including keys
- (void)clearParsedData;

// Sets the parsing attributes -- if data is parsed, clearParsedData is called
- (void)setRecordDelimiter:(NSString *)aValue;
- (void)setFieldDelimiter:(NSString *)aValue;
- (void)setStartingFieldWrapper:(NSString *)aValue;
- (void)setEndingFieldWrapper:(NSString *)aValue;

// returns the record at index - throws exception if index is out of bounds
- (id)objectAtIndex:(unsigned int)index;
// returns a dictionary for the record at the specified index
- (NSDictionary *)dictionaryForObjectAtIndex:(unsigned int)index;
// Returns an array of all records rendered to dictionaries
- (NSArray *)allRecordsAsDictionaries;

// replaces the record at index with an NSNull - useful when doing one pass with huge imports
// if (index > 10){
//		[delimitedDataReader purgeRecordAtIndex:index - 10];	
// }
- (BOOL)purgeRecordAtIndex:(unsigned int)index;
- (void)enableRecordPurging;
- (void)disableRecordPurging;

// returns the parsed value of key (as derived from all keys) at record at index. Throws an exception if the key is unknown. This method tries to be efficient by parsing the record only when asked. Parses the record once, subsequent calls returns the value of the corresponding key as a result of the first parsing
- (id)objectForKey:(NSString *)key atIndex:(unsigned int)index;
- (void)setObject: (id)object forKey: (NSString *)key atIndex: (unsigned int)index;

- (NSArray *) allKeys;
- (unsigned int) count;

- (void)version2ParseRecords;
@end
